<?php
require_once 'config.php';

echo "<h2>🔍 Dijagnostika Analytics Sustava</h2><hr>";

// Test 1: Funkcija postoji?
echo "<strong>Test 1:</strong> Funkcija getPlatformSetting postoji? ";
echo function_exists('getPlatformSetting') ? "✅ DA" : "❌ NE";
echo "<br><br>";

// Test 2: Tablica postoji?
echo "<strong>Test 2:</strong> Platform settings tablica postoji? ";
try {
    $db = getDB();
    $stmt = $db->query('SELECT COUNT(*) FROM platform_settings');
    $count = $stmt->fetchColumn();
    echo "✅ DA (ima $count redaka)";
} catch (Exception $e) {
    echo "❌ NE - Greška: " . $e->getMessage();
}
echo "<br><br>";

// Test 3: Dohvat analytics slug-a
echo "<strong>Test 3:</strong> Analytics slug = ";
try {
    $slug = getPlatformSetting('analytics_slug', 'analitika');
    echo "✅ '$slug'";
} catch (Exception $e) {
    echo "❌ Greška: " . $e->getMessage();
}
echo "<br><br>";

// Test 4: Index.php ima provjeru?
echo "<strong>Test 4:</strong> Čitam index.php...<br>";
$indexContent = file_get_contents('index.php');
if (strpos($indexContent, 'getPlatformSetting') !== false) {
    echo "✅ index.php IMA provjeru za analytics";
} else {
    echo "❌ index.php NEMA provjeru za analytics<br>";
    echo "<span style='color:red;'>PROBLEM JE OVDJE! index.php mora biti zamijenjen!</span>";
}

echo "<hr><h3>Test 5: Simulacija routing-a</h3>";

// Simuliraj što se događa kad odeš na /analitika
$testPath = 'analitika';
$analyticsSlug = getPlatformSetting('analytics_slug', 'analitika');

echo "Path: <code>$testPath</code><br>";
echo "Analytics slug iz baze: <code>$analyticsSlug</code><br>";
echo "Match? " . ($testPath === $analyticsSlug ? "✅ DA" : "❌ NE") . "<br><br>";

// Provjeri redoslijed u index.php
echo "<h3>Test 6: Redoslijed u index.php</h3>";
$lines = file('index.php');
$foundAnalyticsCheck = false;
$foundUserQuery = false;
$analyticsLine = 0;
$userQueryLine = 0;

foreach ($lines as $num => $line) {
    if (!$foundAnalyticsCheck && strpos($line, 'getPlatformSetting') !== false) {
        $foundAnalyticsCheck = true;
        $analyticsLine = $num + 1;
    }
    if (!$foundUserQuery && strpos($line, 'SELECT * FROM users WHERE slug') !== false) {
        $foundUserQuery = true;
        $userQueryLine = $num + 1;
    }
}

echo "Analytics provjera na liniji: <strong>$analyticsLine</strong><br>";
echo "User query na liniji: <strong>$userQueryLine</strong><br><br>";

if ($analyticsLine > 0 && $userQueryLine > 0) {
    if ($analyticsLine < $userQueryLine) {
        echo "✅ Redoslijed je DOBAR (analytics prije user query)";
    } else {
        echo "❌ Redoslijed je LOŠ (user query dolazi prije analytics provjere!)";
    }
} else {
    echo "❌ Nešto nedostaje u index.php";
}

echo "<hr><h3>Test 7: analytics-login.php file</h3>";

if (file_exists('analytics-login.php')) {
    $fileSize = filesize('analytics-login.php');
    echo "✅ File postoji<br>";
    echo "Veličina: <strong>" . number_format($fileSize) . " bytes</strong><br>";
    
    if ($fileSize < 100) {
        echo "❌ <span style='color:red;'>FILE JE PRAZAN ili skoro prazan!</span><br>";
        echo "Mora biti ~5500 bytes!";
    } else {
        echo "✅ File izgleda OK";
    }
} else {
    echo "❌ <span style='color:red;'>FILE NE POSTOJI!</span>";
}

echo "<hr><h3>Test 8: .htaccess pravila</h3>";

if (file_exists('.htaccess')) {
    echo "✅ .htaccess postoji<br><br>";
    echo "<strong>Sadržaj:</strong><br>";
    echo "<pre style='background:#f5f5f5;padding:10px;overflow:auto;max-height:300px;'>";
    echo htmlspecialchars(file_get_contents('.htaccess'));
    echo "</pre>";
} else {
    echo "❌ .htaccess NE postoji";
}
?>