// quick-setup.js - Brzo kreiraj admina i testiranje
const bcrypt = require('bcrypt');
const mysql = require('mysql2/promise');

async function quickSetup() {
  console.log('🔧 TapTap Card - Brzo postavljanje\n');

  // 1. Generiraj hash za lozinku "admin123"
  const password = 'admin123';
  const hash = await bcrypt.hash(password, 10);
  
  console.log('✅ Hash generiran za lozinku: admin123');
  console.log('Hash:', hash);
  console.log('\n📋 Kopiraj ovaj SQL u phpMyAdmin:\n');
  console.log('=' .repeat(80));
  console.log(`DELETE FROM admin_users WHERE username = 'admin';`);
  console.log(`INSERT INTO admin_users (username, password) VALUES ('admin', '${hash}');`);
  console.log('=' .repeat(80));
  
  // 2. Pokušaj spojiti se na bazu i testirati
  try {
    const connection = await mysql.createConnection({
      host: 'localhost',
      user: 'taptapcp_cardbazauser',
      password: '(bC.vE}JY.@G?xCl',
      database: 'taptapcp_cardbaza'
    });
    
    console.log('\n✅ Spojeno na bazu!\n');
    
    // Provjeri koliko korisnika ima
    const [users] = await connection.query('SELECT COUNT(*) as count FROM users');
    console.log(`📊 Broj korisnika u bazi: ${users[0].count}`);
    
    // Provjeri zmadzar korisnika
    const [zmadzar] = await connection.query('SELECT * FROM users WHERE slug = "zmadzar"');
    if (zmadzar.length > 0) {
      console.log('✅ Korisnik zmadzar postoji u bazi');
      console.log('   ID:', zmadzar[0].id);
      console.log('   Ime:', zmadzar[0].ime, zmadzar[0].prezime);
    } else {
      console.log('❌ Korisnik zmadzar NE POSTOJI u bazi!');
      console.log('\n📋 Kopiraj ovaj SQL za kreiranje zmadzar korisnika:\n');
      console.log('=' .repeat(80));
      console.log(`INSERT INTO users (slug, ime, prezime, opis, email, telefon, whatsapp) VALUES 
('zmadzar', 'Zvonimir', 'Madžar', 'Vlasnik marketinške agencije.', 'info@taptap.ba', '+387 63 123 456', '+387 63 123 456');`);
      console.log('=' .repeat(80));
    }
    
    // Provjeri tabele
    const [tables] = await connection.query('SHOW TABLES');
    console.log('\n📋 Tabele u bazi:');
    tables.forEach(table => {
      console.log('  -', Object.values(table)[0]);
    });
    
    await connection.end();
    
  } catch (error) {
    console.log('\n❌ Greška pri spajanju na bazu:');
    console.log('   ', error.message);
    console.log('\n💡 Provjeri:');
    console.log('   1. Je li MySQL server pokrenut?');
    console.log('   2. Jesu li kredencijali točni u .env?');
    console.log('   3. Ima li korisnik privilegije na bazu?');
  }
}

quickSetup().catch(console.error);

// Pokreni: node quick-setup.js