<?php
echo "<h1>Security Check</h1>";

// Check PHP version
echo "<h3>PHP Version: " . phpversion() . "</h3>";
if (version_compare(phpversion(), '7.4', '<')) {
    echo "⚠️ WARNING: PHP verzija je zastarjela!<br>";
}

// Check dangerous functions
$dangerous = ['exec', 'shell_exec', 'system', 'passthru', 'eval'];
foreach ($dangerous as $func) {
    if (function_exists($func)) {
        echo "⚠️ WARNING: Funkcija $func je omogućena!<br>";
    }
}

// Check file permissions
$files = ['config.php', '.htaccess', 'admin.php'];
foreach ($files as $file) {
    if (file_exists($file)) {
        $perms = substr(sprintf('%o', fileperms($file)), -4);
        echo "$file permissions: $perms ";
        if ($perms > '0644') {
            echo "⚠️ Preporuka: chmod 644<br>";
        } else {
            echo "✓<br>";
        }
    }
}

// Check uploads directory
if (is_dir('uploads')) {
    $perms = substr(sprintf('%o', fileperms('uploads')), -4);
    echo "uploads/ permissions: $perms ";
    if ($perms != '0755') {
        echo "⚠️ Preporuka: chmod 755<br>";
    } else {
        echo "✓<br>";
    }
}

// Check .htaccess
if (!file_exists('.htaccess')) {
    echo "⚠️ WARNING: .htaccess ne postoji!<br>";
}

echo "<h3>SSL Check</h3>";
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    echo "✓ SSL je aktivan<br>";
} else {
    echo "⚠️ SSL nije aktivan - OBAVEZNO omogući!<br>";
}

echo "<h3>Database Password Strength</h3>";
$dbPass = '(bC.vE}JY.@G?xCl'; // Iz config.php
if (strlen($dbPass) < 16) {
    echo "⚠️ WARNING: DB lozinka je prekratka!<br>";
} else {
    echo "✓ DB lozinka dovoljno jaka<br>";
}

echo "<h3>JWT Secret Check</h3>";
$jwtSecret = 'tvoj-super-tajni-kljuc-XYZ-promijeni-odmah'; // Iz config.php
if (strlen($jwtSecret) < 32 || strpos($jwtSecret, 'promijeni') !== false) {
    echo "⚠️ CRITICAL: JWT_SECRET mora biti promijenjen!<br>";
} else {
    echo "✓ JWT secret OK<br>";
}
?>